<!-- type: Canvas -->

## V Api Basic

V api in tensorpc **always** starts with a `V.group` context manager. the visualization data will be sent to frontend when the outermost `V.group` context manager exits.

In following code, we create a group named `root`, and add a text node to it. Click run button, then you will see a red text `Hello World!` in the output area.

You can click the `clear` button in top left of 3d canvas to clear the output area.


The V api only available when the UI component `ComplexCanvas` is mounted in your app.

```Python
from tensorpc.flow import V
with V.group("root"):
    V.text("Hello World!").prop(color="red")
```

If you use vapi without any `V.group` context manager, a error will be raised.

```Python
from tensorpc.flow import V
V.text("raise error...").prop(color="red")
```


### 3D component tree

When you draw any data via V api, you can see created 3d component in the right of the complex canvas:

```Python
from tensorpc.flow import V
with V.group("root"):
    V.text("Hello World!").prop(color="red")
```

#### component props

when you select a component in the 3d component tree, you can see the props of the component in the right bottom of the canvas.

**WARNING** the props of component is generated automatically, don't touch the prop you don't know.

#### Exercise

* run code block above, then click the `root` node in the 3d component tree, expand it and you will see the text component. 

* click the text component, then you will see the props of text. drag the `position` and `rotation` props, you will see the text component move and rotate in the canvas. click the `color` prop to change color of the text.

* click the `visibility` button in component tree to make the text invisible.

* click the `delete` button in root node in component tree to remove components you draw.